/*=====================================================================
  Project:   Netrix.bdsproj

  File:      WinForm.cs

  Summary:   By recreating a popular game, this simple project
             demonstrates how to use System.Drawing capabilities
             of .NET Framework, and how to handle keyboard key
             strokes in your .NET application.

---------------------------------------------------------------------

	 Example submitted by Alfred Mirzagitov

=====================================================================*/
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Netrix
{

  /// <summary>
  /// Netrix MainForm.
  /// </summary>
  public class WinForm : System.Windows.Forms.Form
  {
    /// <summary>
    /// Required designer variable.
    /// </summary>
    private System.ComponentModel.Container components = null;
    private System.Windows.Forms.Panel CtrlPanel;
    
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.Label label5;
    private System.Windows.Forms.Label label6;
    private System.Windows.Forms.Label label7;
    private System.Windows.Forms.MainMenu mainMenu1;
    private System.Windows.Forms.MenuItem MainLabel;
    private System.Windows.Forms.MenuItem menuItem2;
    private System.Windows.Forms.StatusBar ScoreBar;

    public WinForm()
    {
      //
      // Required for Windows Form Designer support
      //
      InitializeComponent();
      //
      // TODO: Add any constructor code after InitializeComponent call
      //
    }

    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    protected override void Dispose (bool disposing)
    {
      if (disposing)
      {
        if (components != null)
        {
          components.Dispose();
        }
      }
      base.Dispose(disposing);
    }

    #region Windows Form Designer generated code
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    private void InitializeComponent()
    {
      this.CtrlPanel = new System.Windows.Forms.Panel();
      this.label7 = new System.Windows.Forms.Label();
      this.label6 = new System.Windows.Forms.Label();
      this.label5 = new System.Windows.Forms.Label();
      this.label4 = new System.Windows.Forms.Label();
      this.label3 = new System.Windows.Forms.Label();
      this.mainMenu1 = new System.Windows.Forms.MainMenu();
      this.MainLabel = new System.Windows.Forms.MenuItem();
      this.menuItem2 = new System.Windows.Forms.MenuItem();
      this.ScoreBar = new System.Windows.Forms.StatusBar();
      this.CtrlPanel.SuspendLayout();
      this.SuspendLayout();
      // 
      // CtrlPanel
      // 
      this.CtrlPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
      this.CtrlPanel.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.CtrlPanel.Controls.Add(this.label7);
      this.CtrlPanel.Controls.Add(this.label6);
      this.CtrlPanel.Controls.Add(this.label5);
      this.CtrlPanel.Controls.Add(this.label4);
      this.CtrlPanel.Controls.Add(this.label3);
      this.CtrlPanel.Location = new System.Drawing.Point(0, 0);
      this.CtrlPanel.Name = "CtrlPanel";
      this.CtrlPanel.Size = new System.Drawing.Size(176, 248);
      this.CtrlPanel.TabIndex = 0;
      // 
      // label7
      // 
      this.label7.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
      this.label7.AutoSize = true;
      this.label7.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
      this.label7.Location = new System.Drawing.Point(16, 200);
      this.label7.Name = "label7";
      this.label7.Size = new System.Drawing.Size(69, 16);
      this.label7.TabIndex = 7;
      this.label7.Text = "Space - drop";
      // 
      // label6
      // 
      this.label6.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
      this.label6.AutoSize = true;
      this.label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
      this.label6.Location = new System.Drawing.Point(16, 184);
      this.label6.Name = "label6";
      this.label6.Size = new System.Drawing.Size(87, 16);
      this.label6.TabIndex = 6;
      this.label6.Text = "UpArrow - rotate";
      // 
      // label5
      // 
      this.label5.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
      this.label5.AutoSize = true;
      this.label5.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
      this.label5.Location = new System.Drawing.Point(16, 168);
      this.label5.Name = "label5";
      this.label5.Size = new System.Drawing.Size(123, 16);
      this.label5.TabIndex = 5;
      this.label5.Text = "RightArrow - move right";
      // 
      // label4
      // 
      this.label4.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
      this.label4.AutoSize = true;
      this.label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
      this.label4.Location = new System.Drawing.Point(16, 152);
      this.label4.Name = "label4";
      this.label4.Size = new System.Drawing.Size(108, 16);
      this.label4.TabIndex = 4;
      this.label4.Text = "LeftArrow - move left";
      // 
      // label3
      // 
      this.label3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
      this.label3.AutoSize = true;
      this.label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
      this.label3.Location = new System.Drawing.Point(8, 136);
      this.label3.Name = "label3";
      this.label3.Size = new System.Drawing.Size(72, 16);
      this.label3.TabIndex = 3;
      this.label3.Text = "Control Keys:";
      // 
      // mainMenu1
      // 
      this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.MainLabel,
            this.menuItem2});
      // 
      // MainLabel
      // 
      this.MainLabel.Index = 0;
      this.MainLabel.Text = "&Click here to Start";
      this.MainLabel.Click += new System.EventHandler(this.label1_Click);
      // 
      // menuItem2
      // 
      this.menuItem2.Index = 1;
      this.menuItem2.Text = "Click here to Quit";
      this.menuItem2.Click += new System.EventHandler(this.label2_Click);
      // 
      // ScoreBar
      // 
      this.ScoreBar.Location = new System.Drawing.Point(0, 260);
      this.ScoreBar.Name = "ScoreBar";
      this.ScoreBar.Size = new System.Drawing.Size(408, 22);
      this.ScoreBar.TabIndex = 1;
      this.ScoreBar.Text = "Score: 0";
      // 
      // WinForm
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(408, 282);
      this.Controls.Add(this.ScoreBar);
      this.Controls.Add(this.CtrlPanel);
      this.Menu = this.mainMenu1;
      this.Name = "WinForm";
      this.Text = "NETrix";
      this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.WinForm_KeyDown);
      this.Resize += new System.EventHandler(this.WinForm_Resize);
      this.CtrlPanel.ResumeLayout(false);
      this.ResumeLayout(false);
    }
    #endregion

    /// <summary>
    /// The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main()
    {
      Application.Run(new WinForm());
    }

    private enum GameState
    {
      gsBrandNew,
      gsInProgress,
      gsPaused,
      gsOver
    }
    private GameState theGame=GameState.gsBrandNew;
    private int CurrentScore = 0;
    private PlayingField f = null;

    private void WinForm_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
    {
      if (f == null) return;
      switch(e.KeyCode) {
        case Keys.Left:   f.GoLeft();                break;
        case Keys.Right:  f.GoRight();               break;
        case Keys.Up:     f.TurnClockwise();         break;
        case Keys.Down:   f.GoDown();                break;
        case Keys.Clear:  f.TurnCounterclockwise();  break;
        case Keys.Space:  f.Drop();                  break;
      }
    }

    private void WinForm_Resize(object sender, System.EventArgs e)
    {
      if (f != null) {
        f.Location = new System.Drawing.Point(ClientSize.Width/2, 0);
        f.Size = new System.Drawing.Size(ClientSize.Width/2, ClientSize.Height-ScoreBar.Height - 1);
        f.Invalidate();
      }

      if (CtrlPanel != null) {
        CtrlPanel.Size = new System.Drawing.Size(ClientSize.Width/2, ClientSize.Height-ScoreBar.Height - 1);
        CtrlPanel.Invalidate();
      }
    }

    private void label1_Click(object sender, System.EventArgs e)
    {
      switch (theGame) {
        case GameState.gsInProgress:
          f.PauseGame();
          MainLabel.Text = "Click to Resume";
          theGame = GameState.gsPaused;
          break;
        case GameState.gsPaused:
          f.ResumeGame();
          MainLabel.Text = "Click to Pause";
          theGame = GameState.gsInProgress;
          break;
        default:
          MainLabel.Text = "Click to Pause";
          theGame = GameState.gsInProgress;
          NewGame();
          break;
      }
    }

    private void label2_Click(object sender, System.EventArgs e)
    {
      Close();
    }

    private void NewGame()
    {
      ScoreBar.Text = "Score: 0";
      if (f == null)
        f = new PlayingField(this,
                             ClientSize.Width / 2,
                             0,
                             ClientSize.Width / 2,
                             ClientSize.Height - ScoreBar.Height - 1);
      f.NewGame();
    }

    public void AddScore(int score)
    {
      CurrentScore = CurrentScore + score;
      ScoreBar.Text = "Score: "+CurrentScore;
    }

    public void GameOver()
    {
      MainLabel.Text = "Click for a new Game";
      theGame = GameState.gsOver;
    }
  }
}
